/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.persistance;

import ifs.docman.lotusnotes.enumerations.EmailSaveOptions;
import ifs.docman.lotusnotes.io.RegistryManager;
import ifs.docman.lotusnotes.model.RegistryObjectModel;
import java.lang.reflect.InvocationTargetException;

public class UserSettingsManager {
    private static final String IS_CLICK_ONCE_DEPLOYED_SELECTED_VALUE = "YES";
    private static final String IS_CLICK_ONCE_DEPLOYED_NOT_SELECTED_VALUE = "NO";

    static {
        try {
            RegistryManager.createKey(-2147483647, "Software\\IFS\\Document Management\\Settings");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static RegistryObjectModel loadFromRegistry() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryObjectModel model = new RegistryObjectModel();
        String currentLanguage = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "Language");
        if (currentLanguage == null || "".equals(currentLanguage)) {
            currentLanguage = "en";
        }
        model.Language = currentLanguage;
        model.DocumentationBaseUrl = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "DocumentationBaseUrl");
        model.LocalCheckoutPath = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "DocumentFolder");
        model.IeePath = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "IeePath");
        model.IeeUrl = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "IeeUrl");
        String isClickOnceDeployed = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "IsClickOnceDeployed");
        if (isClickOnceDeployed == null || "".equals(isClickOnceDeployed)) {
            isClickOnceDeployed = IS_CLICK_ONCE_DEPLOYED_SELECTED_VALUE;
        }
        model.IsClickOnceDeployed = IS_CLICK_ONCE_DEPLOYED_SELECTED_VALUE.equals(isClickOnceDeployed);
        String emailSaveOptions = RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", "EmailSaveOptions");
        if (emailSaveOptions == null || "".equals(emailSaveOptions)) {
            emailSaveOptions = EmailSaveOptions.CompleteEmail.toString();
        }
        model.EmailSaveOptions = emailSaveOptions;
        return model;
    }

    public static void storeInRegistry(RegistryObjectModel model) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "Language", model.Language);
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "DocumentationBaseUrl", model.DocumentationBaseUrl);
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "DocumentFolder", model.LocalCheckoutPath);
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "IeePath", model.IeePath);
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "IeeUrl", model.IeeUrl);
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "IsClickOnceDeployed", model.IsClickOnceDeployed ? IS_CLICK_ONCE_DEPLOYED_SELECTED_VALUE : IS_CLICK_ONCE_DEPLOYED_NOT_SELECTED_VALUE);
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", "EmailSaveOptions", model.EmailSaveOptions);
    }

    public static void write(String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryManager.writeStringValue(-2147483647, "Software\\IFS\\Document Management\\Settings", key, value);
    }

    public static String read(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return RegistryManager.readString(-2147483647, "Software\\IFS\\Document Management\\Settings", key);
    }
}

