/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.io;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

public class RegistryManager {
    public static final String SETTINGS_KEY = "Software\\IFS\\Document Management\\Settings";
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Method regMethodOpenKey = null;
    private static Method regMethodCloseKey = null;
    private static Method regMethodQueryValueEx = null;
    private static Method regMethodSetValueEx = null;
    private static Method regMethodCreateKeyEx = null;
    private static Method regMethodDeleteKey = null;
    private static Method regMethodDeleteValue = null;

    static {
        try {
            regMethodOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regMethodOpenKey.setAccessible(true);
            regMethodCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regMethodCloseKey.setAccessible(true);
            regMethodQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regMethodQueryValueEx.setAccessible(true);
            regMethodSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regMethodSetValueEx.setAccessible(true);
            regMethodCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regMethodCreateKeyEx.setAccessible(true);
            regMethodDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regMethodDeleteKey.setAccessible(true);
            regMethodDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regMethodDeleteValue.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] ret;
        if (hkey == -2147483646) {
            ret = RegistryManager.createKey(systemRoot, hkey, key);
            regMethodCloseKey.invoke((Object)systemRoot, new Integer(ret[0]));
        } else if (hkey == -2147483647) {
            ret = RegistryManager.createKey(userRoot, hkey, key);
            regMethodCloseKey.invoke((Object)userRoot, new Integer(ret[0]));
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        if (ret[1] != 0) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    private static int[] createKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regMethodCreateKeyEx.invoke((Object)root, new Integer(hkey), RegistryManager.toCstr(key));
    }

    public static void deleteKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == -2147483646) {
            rc = RegistryManager.deleteKey(systemRoot, hkey, key);
        } else if (hkey == -2147483647) {
            rc = RegistryManager.deleteKey(userRoot, hkey, key);
        }
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    private static int deleteKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = (Integer)regMethodDeleteKey.invoke((Object)root, new Integer(hkey), RegistryManager.toCstr(key));
        return rc;
    }

    public static void deleteValue(int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == -2147483646) {
            rc = RegistryManager.deleteValue(systemRoot, hkey, key, value);
        } else if (hkey == -2147483647) {
            rc = RegistryManager.deleteValue(userRoot, hkey, key, value);
        }
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private static int deleteValue(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regMethodOpenKey.invoke((Object)root, new Integer(hkey), RegistryManager.toCstr(key), new Integer(983103));
        if (handles[1] != 0) {
            return handles[1];
        }
        int rc = (Integer)regMethodDeleteValue.invoke((Object)root, new Integer(handles[0]), RegistryManager.toCstr(value));
        regMethodCloseKey.invoke((Object)root, new Integer(handles[0]));
        return rc;
    }

    public static String readString(int hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return RegistryManager.readString(systemRoot, hkey, key, valueName);
        }
        if (hkey == -2147483647) {
            return RegistryManager.readString(userRoot, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regMethodOpenKey.invoke((Object)root, new Integer(hkey), RegistryManager.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        byte[] valb = (byte[])regMethodQueryValueEx.invoke((Object)root, new Integer(handles[0]), RegistryManager.toCstr(value));
        regMethodCloseKey.invoke((Object)root, new Integer(handles[0]));
        return valb != null ? new String(valb).trim() : "";
    }

    public static void writeStringValue(int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            RegistryManager.writeStringValue(systemRoot, hkey, key, valueName, value);
        } else if (hkey == -2147483647) {
            RegistryManager.writeStringValue(userRoot, hkey, key, valueName, value);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
    }

    private static void writeStringValue(Preferences root, int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regMethodOpenKey.invoke((Object)root, new Integer(hkey), RegistryManager.toCstr(key), new Integer(983103));
        regMethodSetValueEx.invoke((Object)root, new Integer(handles[0]), RegistryManager.toCstr(valueName), RegistryManager.toCstr(value));
        regMethodCloseKey.invoke((Object)root, new Integer(handles[0]));
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }
}

